Attribute VB_Name = "modStyles"
Option Explicit
Public TimeStamp As TIMESTAMP_STRUCT, ClanColor As CLANCOLOR_STRUCT, PingColor As PINGCOLOR_STRUCT
Private ChatColor() As CHATCOLOR_STRUCT, UserColor() As USERCOLOR_STRUCT, ChatEvent() As CHATEVENT_STRUCT, ClanNameColor() As CLANNAME_STRUCT
Private colSelf As Long, colSilence As Long, colFilter As Long, colIdleL As Long, colIdleM As Long, colIdleH As Long, colInvisible As Long

Public CurrentStyle As String

Public Type TIMESTAMP_STRUCT
    ts_layout As String
    ts_color As Long
    ts_format As String
End Type

Public Type CHATCOLOR_STRUCT
    cc_colorstr As String
    cc_color As Long
End Type

Public Type CLANCOLOR_STRUCT
    cl_initiate As Long
    cl_peon As Long
    cl_grunt As Long
    cl_shaman As Long
    cl_chief As Long
    cl_clan As Long
    cl_yourclan As Long
End Type

Public Type CLANNAME_STRUCT
    cn_tag As String
    cn_color As Long
End Type

Public Type USERCOLOR_STRUCT
    uc_flag As Long
    uc_color As Long
End Type

Public Type PINGCOLOR_STRUCT
    pc_ext As Long
    pc_vhi As Long
    pc_hi As Long
    pc_med As Long
    pc_lo As Long
    pc_vlo As Long
    pc_zero As Long
    pc_neg As Long
End Type

Public Type CHATEVENT_STRUCT
    ce_eid As Long
    ce_string As String
End Type

Dim strLog As String

Public Sub ImportStyles()
    Dim F() As String, I As Integer
    F = FileList(AppData & "Styles\*.ini")
    With frmBot
        For I = .mnuStyle.UBound To 1 Step -1
            Unload .mnuStyle(I)
        Next I
        .mnuStyle(0).Caption = vbNullString
        For I = 0 To UBound(F)
            If LenB(F(I)) > 4 Then
                If LenB(.mnuStyle(0).Caption) = 0 Then
                    .mnuStyle(0).Caption = Prefix(F(I), ".")
                Else
                    Load .mnuStyle(.mnuStyle.Count)
                    .mnuStyle(.mnuStyle.UBound).Caption = Prefix(F(I), ".")
                End If
                .mnuStyle(.mnuStyle.UBound).Checked = (LCase$(.mnuStyle(.mnuStyle.UBound).Caption) = LCase$(CurrentStyle))
            End If
        Next I
    End With
End Sub

Public Sub ApplyStyle(strStyle As String)
    On Error Resume Next
    ReDim ChatColor(0), UserColor(0), ChatEvent(0), ClanNameColor(0)
    If LenB(strStyle) = 0 Then strStyle = "MirageBot"

    Dim F As New FileSystemObject, TS As TextStream, File As String
    File = AppData & "Styles\" & strStyle & ".ini"
    If F.FileExists(File) = False Then Exit Sub
    Set TS = F.OpenTextFile(File, ForReading)
    Do Until TS.AtEndOfStream
        Dim LN As String, Bracket As Boolean, Section As String
        LN = TS.ReadLine
        Select Case LCase$(Trim$(LN))
        Case "timestamp {"
            Bracket = True
            Section = "ts"
            GoTo NextLine:
        Case "chat_colors {"
            Bracket = True
            Section = "cc"
            GoTo NextLine:
        Case "user_colors {"
            Bracket = True
            Section = "uc"
            GoTo NextLine:
        Case "clan_colors {"
            Bracket = True
            Section = "cl"
            GoTo NextLine:
        Case "clan_name {"
            Bracket = True
            Section = "cn"
            GoTo NextLine:
        Case "ping_colors {"
            Bracket = True
            Section = "pc"
            GoTo NextLine:
        Case "events {"
            Bracket = True
            Section = "ce"
            GoTo NextLine:
        Case "}"
            Bracket = False
            Section = vbNullString
            GoTo NextLine:
        End Select
        'ignore comments
        If Left$(LN, 2) = "//" Then GoTo NextLine:
        
        'Debug.Print LN
        'check if inside a bracket
        If Bracket Then
            'check for colon
            If InStr(LN, ":") > 0 Then
                'split by colon
                Dim Splt() As String
                Splt() = Split(Trim$(LN), ":", 2)
                'check for semi-colon terminator
                If InStr(Splt(1), ";") > 0 Then
                    Dim Field As String, Value As String
                    'get trimmed field
                    Field = Replace$(Trim$(Splt(0)), vbTab, vbNullString)
                    'get text before semi-colon
                    Value = Replace$(Trim$(Split(Splt(1), ";")(0)), vbTab, vbNullString)
                    'handle ln depending on section
                    Select Case Section
                    Case "ts"
                        'timestamp {
                        '    layout: [%TIME%];
                        '    color: #white#;
                        '    format: HH:MM:SS;
                        '}
                        Select Case LCase$(Field)
                        Case "layout"
                            TimeStamp.ts_layout = Replace$(Value, "$sp", " ")
                        Case "format"
                            TimeStamp.ts_format = Value
                        Case "color"
                            TimeStamp.ts_color = Hex2Color(Value)
                        End Select
                    Case "cc"
                        'chat_colors {
                        '    white: FFFFFF;
                        '}
                        If LenB(ChatColor(0).cc_colorstr) = 0 Then
                            ChatColor(0).cc_colorstr = LCase$(Field)
                            ChatColor(0).cc_color = Hex2Color(Value)
                        Else
                            ReDim Preserve ChatColor(UBound(ChatColor) + 1)
                            ChatColor(UBound(ChatColor)).cc_colorstr = LCase$(Field)
                            ChatColor(UBound(ChatColor)).cc_color = Hex2Color(Value)
                        End If
                    Case "uc"
                        'user_colors {
                        '    0x00000001: ; //Blizzard Representative
                        '}
                        Select Case LCase$(Field)
                        Case "self"
                            colSelf = Hex2Color(Value)
                        Case "invisible"
                            colInvisible = Hex2Color(Value)
                        Case "silenced"
                            colSilence = Hex2Color(Value)
                        Case "filtered"
                            colFilter = Hex2Color(Value)
                        Case "idlel"
                            colIdleL = Hex2Color(Value)
                        Case "idlem"
                            colIdleM = Hex2Color(Value)
                        Case "idleh"
                            colIdleH = Hex2Color(Value)
                        Case Else
                            If Left$(Field, 2) = "0x" Then
                                If UserColor(0).uc_color = 0 Then
                                    UserColor(0).uc_flag = Val("&H0" & Mid$(Field, 3))
                                    UserColor(0).uc_color = Hex2Color(Value)
                                Else
                                    ReDim Preserve UserColor(UBound(UserColor) + 1)
                                    UserColor(UBound(UserColor)).uc_flag = Val("&H0" & Mid$(Field, 3))
                                    UserColor(UBound(UserColor)).uc_color = Hex2Color(Value)
                                End If
                            End If
                        End Select
                    Case "cn"
                        If LenB(Trim$(Field)) > 0 Then
                            If ClanNameColor(0).cn_color = 0 Then
                                ClanNameColor(0).cn_color = Hex2Color(Value)
                                ClanNameColor(0).cn_tag = UCase$(Trim$(Field))
                            Else
                                ReDim Preserve ClanNameColor(UBound(ClanNameColor) + 1)
                                ClanNameColor(UBound(ClanNameColor)).cn_color = Hex2Color(Value)
                                ClanNameColor(UBound(ClanNameColor)).cn_tag = UCase$(Trim$(Field))
                            End If
                        End If
                    Case "cl"
                        'clan_colors {
                        '    0x00: ; //Initiate
                        '    0x01: ; //Peon
                        '    0x02: ; //Grunt
                        '    0x03: ; //Shaman
                        '    0x04: ; //Chieftain
                        '}
                        Select Case LCase$(Field)
                            Case "0x00": ClanColor.cl_initiate = Hex2Color(Value)
                            Case "0x01": ClanColor.cl_peon = Hex2Color(Value)
                            Case "0x02": ClanColor.cl_grunt = Hex2Color(Value)
                            Case "0x03": ClanColor.cl_shaman = Hex2Color(Value)
                            Case "0x04": ClanColor.cl_chief = Hex2Color(Value)
                            Case "clan": ClanColor.cl_clan = Hex2Color(Value)
                            Case "yourclan": ClanColor.cl_yourclan = Hex2Color(Value)
                        End Select
                    Case "pc"
                        'ping_colors {
                        '    >600: FF0000; //Extreme
                        '}
                        Select Case Field
                            Case ">600": PingColor.pc_ext = Hex2Color(Value)
                            Case ">500": PingColor.pc_vhi = Hex2Color(Value)
                            Case ">400": PingColor.pc_hi = Hex2Color(Value)
                            Case ">300": PingColor.pc_med = Hex2Color(Value)
                            Case ">200": PingColor.pc_lo = Hex2Color(Value)
                            Case ">9": PingColor.pc_vlo = Hex2Color(Value)
                            Case "=0": PingColor.pc_zero = Hex2Color(Value)
                            Case "<0": PingColor.pc_neg = Hex2Color(Value)
                        End Select
                    Case "ce"
                        'events {
                        '    0x00: #blue#<#ucol#$user#blue#> $message;               //broadcast
                        '}
                        If Left$(Field, 2) = "0x" Then
                            If LenB(ChatEvent(0).ce_string) = 0 Then
                                ChatEvent(0).ce_eid = Val("&H0" & Mid$(Field, 3))
                                ChatEvent(0).ce_string = Value
                            Else
                                ReDim Preserve ChatEvent(UBound(ChatEvent) + 1)
                                ChatEvent(UBound(ChatEvent)).ce_eid = Val("&H0" & Mid$(Field, 3))
                                ChatEvent(UBound(ChatEvent)).ce_string = Value
                            End If
                        End If
                    End Select
                End If
            End If
        End If
        
NextLine:
    Loop
    TS.Close
    
    CurrentStyle = strStyle
    
    Dim I As Integer
    With frmBot.mnuStyle
        For I = 0 To .UBound
            .Item(I).Checked = LCase$(.Item(I).Caption) = LCase$(CurrentStyle)
        Next I
    End With
    
    WriteINI AppSettings, "Settings", "TheStyle", strStyle
    RefreshChannel
    'Debug.Print "Loaded style: " & strStyle
    'Debug.Print "- Chat Colors: " & UBound(ChatColor)
    'Debug.Print "- Chat Events: " & UBound(ChatEvent)
    'Debug.Print "- User Colors: " & UBound(UserColor)
End Sub

Public Function GetPingColor(ByVal Ping As Long) As Long
    If Ping = -1 Then GetPingColor = PingColor.pc_neg: Exit Function
    If Ping > 600 Then GetPingColor = PingColor.pc_ext: Exit Function
    If Ping > 500 Then GetPingColor = PingColor.pc_vhi: Exit Function
    If Ping > 400 Then GetPingColor = PingColor.pc_hi: Exit Function
    If Ping > 300 Then GetPingColor = PingColor.pc_med: Exit Function
    If Ping > 200 Then GetPingColor = PingColor.pc_lo: Exit Function
    If Ping > 9 Then GetPingColor = PingColor.pc_vlo: Exit Function
    GetPingColor = PingColor.pc_zero
    If GetPingColor = -1 Then GetPingColor = vbWhite
End Function

Private Function GetChatColor(strColor As String)
    Dim I As Integer
    strColor = LCase$(strColor)
    For I = 0 To UBound(ChatColor)
        'compare strings
        If ChatColor(I).cc_colorstr = strColor Then
            GetChatColor = ChatColor(I).cc_color
            Exit Function
        End If
    Next I
    GetChatColor = vbWhite
End Function

Public Function GetUserColor(Index As Integer, Username As String, Flags As Long) As Long
    'Check for Your color
    If LCase$(frmBot.Bot(Index).Self.Username) = LCase$(Suffix(Username)) Then
        If colSelf <> 0 Then GetUserColor = colSelf: Exit Function
    End If
    'Check for Clan Color
    With frmBot.Bot(Index)
        If IsFiltered(Username, True) Then GetUserColor = colFilter: Exit Function
        Dim U As clsUser
        Set U = .Users.GetByName(Username)
        If Not U Is Nothing Then
            If U.IsSilenced And colSilence > 0 Then GetUserColor = colSilence: Exit Function
            If U.IsInvisible And colInvisible > 0 Then GetUserColor = colInvisible: Exit Function
            If Options.IdleDim Then
                If U.IsIdle And colIdleL > 0 Then GetUserColor = colIdleL: Exit Function
                If U.IsIdler And colIdleM > 0 Then GetUserColor = colIdleM: Exit Function
                If U.IsIdlest And colIdleH > 0 Then GetUserColor = colIdleH: Exit Function
            End If
        End If
        Dim C As Integer
        For C = 0 To UBound(ClanNameColor)
            If LenB(ClanNameColor(C).cn_tag) > 0 Then
                If UCase$(GetClanName(U.Statstring)) = ClanNameColor(C).cn_tag Then
                    GetUserColor = ClanNameColor(C).cn_color: Exit Function
                End If
            End If
        Next C
        If Options.ClanRankColors = False Then
            If .Clan.InClan Then
                Dim CM As New clsClanMember
                Set CM = .Clan.GetByName(Username)
                If Not CM Is Nothing Then
                    If LenB(CM.Username) > 0 Then
                        Select Case CM.Rank
                            Case 0: GetUserColor = ClanColor.cl_initiate: If GetUserColor = 0 Then GoTo FindColor Else Exit Function
                            Case 1: GetUserColor = ClanColor.cl_peon: If GetUserColor = 0 Then GoTo FindColor Else Exit Function
                            Case 2: GetUserColor = ClanColor.cl_grunt: If GetUserColor = 0 Then GoTo FindColor Else Exit Function
                            Case 3: GetUserColor = ClanColor.cl_shaman: If GetUserColor = 0 Then GoTo FindColor Else Exit Function
                            Case 4: GetUserColor = ClanColor.cl_chief: If GetUserColor = 0 Then GoTo FindColor Else Exit Function
                        End Select
                    End If
                End If
            End If
        End If
    End With
FindColor:
    'Check for Group Color
    Dim X As Long
    X = GetGroupColor(Suffix(Username))
    If X <> -1 Then GetUserColor = X: Exit Function
    'Check for User Color
    Dim I As Integer
    For I = 0 To UBound(UserColor)
        If UserColor(I).uc_flag And Flags Then
            GetUserColor = UserColor(I).uc_color: Exit Function
        End If
    Next I
    'No Color use Previous Color in Event String
    GetUserColor = -1
End Function

Public Sub OutputTime(rtb As RichTextBox)
    If TimeStamp.ts_color = vbBlack Then TimeStamp.ts_color = vbWhite
    With rtb
        If LenB(ChatFont) = 0 Then ChatFont = "Tahoma"
        If Val(ChatFontSize) = 0 Then ChatFontSize = 11
        If (UBound(Split(.Text, vbCrLf)) >= 349) Then
            .SelStart = 0
            .SelLength = (0.75 * Len(.Text))
            .SelText = vbNullString
            .SelLength = (InStr(1, .Text, vbCrLf, vbTextCompare) + 1)
            .SelText = vbNullString
        End If
        .SelStart = 2000000000
        .SelFontName = ChatFont
        .SelBold = False
        .SelUnderline = False
        .SelStrikeThru = False
        .SelItalic = False
        .SelHangingIndent = 1370
        .SelFontSize = ChatFontSize
        .SelColor = TimeStamp.ts_color
        If Options.PlainText Then .SelColor = vbWhite
        .SelText = Replace$(TimeStamp.ts_layout, "$time", Format$(Time, TimeStamp.ts_format))
        .SelStart = 2000000000
        If rtb.Name = "rtbChat" Then
            With frmBot.Bot(rtb.Index).Config
                If .Logging = 1 Then
                    strLog = HTMLFormat(TimeStamp.ts_color, Replace$(TimeStamp.ts_layout, "$time", Format$(Time, TimeStamp.ts_format)))
                ElseIf .Logging = 2 Then
                    strLog = Replace$(TimeStamp.ts_layout, "$time", Format$(Time, TimeStamp.ts_format))
                End If
            End With
        End If
    End With
End Sub

Public Sub OutputPart(rtb As RichTextBox, color As Long, Message As String, _
        Optional DisableFormat As Boolean = True)
    Dim CurPos As Double
    If color = vbBlack Then color = vbWhite
    With rtb
        If LenB(ChatFont) = 0 Then ChatFont = "Tahoma"
        If Val(ChatFontSize) = 0 Then ChatFontSize = 11
        If (UBound(Split(.Text, vbCrLf)) >= 349) Then
            .SelStart = 0
            .SelLength = (0.75 * Len(.Text))
            .SelText = vbNullString
            .SelLength = (InStr(1, .Text, vbCrLf, vbTextCompare) + 1)
            .SelText = vbNullString
        End If
        .SelStart = 2000000000
         CurPos = Len(.Text)
        .SelFontName = ChatFont
        .SelFontSize = ChatFontSize
        .SelBold = False
        .SelUnderline = False
        .SelStrikeThru = False
        .SelItalic = False
        .SelHangingIndent = 1370
        .SelColor = color
         If Options.PlainText And Not DisableFormat Then .SelColor = vbWhite
        .SelText = Message
        .SelStart = 2000000000
         If Not DisableFormat Then
            If Options.Smileys Then ReplaceEmoticons rtb, CurPos
            If Options.Colors Then ReplaceColours rtb, CurPos
         End If
        If rtb.Name = "rtbChat" Then
            With frmBot.Bot(rtb.Index).Config
                If .Logging = 1 Then
                    strLog = strLog & HTMLFormat(color, Message)
                    If InStr(strLog, vbNewLine) Then
                        LogHTML rtb.Index, strLog
                        strLog = vbNullString
                    End If
                ElseIf .Logging = 2 Then
                    strLog = strLog & Message
                    If InStr(strLog, vbNewLine) Then
                        LogText rtb.Index, strLog
                        strLog = vbNullString
                    End If
                End If
            End With
        End If
    End With
End Sub

Public Sub OutputEventFocus(rtb As RichTextBox, Index As Integer, EID As Long, _
        Optional Username As String = vbNullString, _
        Optional Message As String = vbNullString, _
        Optional Flags As Long = 0, _
        Optional Ping As Long = 0, _
        Optional Uptime As String = vbNullString, _
        Optional Extra As String = vbNullString, _
        Optional NoTime As Boolean = False)
On Error GoTo hErr:
    Dim ucol As Long, urank As String, xdb As clsDatabaseUser, xfind As Integer, clsClan As String
    'get user color value
    If Index > -1 And LenB(Username) Then
1       ucol = GetUserColor(Index, Username, Flags)
        xfind = frmBot.Bot(Index).Database.Find(Username)
2       If xfind > -1 Then
            Set xdb = frmBot.Bot(Index).Database.GetUser(xfind)
3           If Not xdb Is Nothing Then urank = GetRankByID(xdb.RankID).RankName
        End If
4       xfind = frmBot.Bot(Index).Clan.Find(Username)
5       If xfind <> -1 Then clsClan = ClanRankToString(frmBot.Bot(Index).Clan.GetByIndex(xfind).Rank)
    End If
    'output time first
6   If Not NoTime Then OutputTime rtb
    'loop thru chat event strings
    Dim I As Integer, lcol As Long
7   For I = 0 To UBound(ChatEvent)
        'found eid
8       If ChatEvent(I).ce_eid = EID Then
            Dim buf As String, ssharp As Long, esharp As Long, scol As String, slen As Long, talk As Boolean
            'get talk bool
9           talk = (EID = EID_TALK Or EID = EID_WHISPER Or EID = EID_WHISPERSENT Or EID = EID_EMOTE Or EID = &HA2 Or EID = &HA3 Or EID = &HA4)
            'get buf
10          buf = ChatEvent(I).ce_string
11          Do Until Len(buf) = 0
                'get first sharp
12              ssharp = InStr(1, buf, "#")
13              If ssharp = 0 Then GoTo Output:
                'get next sharp
14              esharp = InStr(ssharp + 1, buf, "#")
15              If esharp = 0 Then GoTo Output
                'get color name
16              scol = Mid$(buf, ssharp + 1, esharp - ssharp - 1)
                'get len for later
17              slen = InStr(esharp + 1, buf, "#")
                'check if the color == #ucol#
18              If UCase$(scol) = "UCOL" Then
                    'get usercolor is not -1
19                  If ucol <> -1 Then lcol = ucol
                Else
                    'get chatcolor
20                  lcol = GetChatColor(scol)
                End If
Output:
                Dim stmp As String, stats As String
                'check length
                If slen > 0 Then
                    'get part
21                  stmp = Mid$(buf, esharp + 1, slen - esharp - 1)
22                  stats = GetClientStats(Message)
23                  If LenB(stats) = 0 Then
24                      If Left$(Message, 4) = "VD2D" Or Left$(Message, 4) = "PX2D" Then
25                          stats = "open char"
                        Else
26                          stats = "no stats"
                        End If
                    End If
                    'replace vars
                    If InStrB(stmp, "$flags_dec") <> 0 Then stmp = Replace$(stmp, "$flags_dec", Flags)
27                  If InStrB(stmp, "$flags_raw") <> 0 Then stmp = Replace$(stmp, "$flags_raw", LongToHex(Flags))
28                  If InStrB(stmp, "$flags") <> 0 Then stmp = Replace$(stmp, "$flags", FlagsToString(Flags))
29                  If InStrB(stmp, "$ping") <> 0 Then stmp = Replace$(stmp, "$ping", Ping)
                    If InStrB(stmp, "$clan") <> 0 Then stmp = Replace$(stmp, "$clan", GetClanName(Message))
30                  If InStrB(stmp, "$user") <> 0 Then stmp = Replace$(stmp, "$user", GetTag(Username, True))
31                  If InStrB(stmp, "$uptime") <> 0 Then stmp = Replace$(stmp, "$uptime", Uptime)
32                  If InStrB(stmp, "$client") <> 0 Then stmp = Replace$(stmp, "$client", GetClientName(StrReverse$(Left$(Message, 4))))
33                  If InStrB(stmp, "$stats") <> 0 Then stmp = Replace$(stmp, "$stats", stats)
34                  If InStrB(stmp, "$channel") <> 0 Then stmp = Replace$(stmp, "$channel", Message)
35                  If InStrB(stmp, "$chflags_raw") <> 0 Then stmp = Replace$(stmp, "$chflags_raw", LongToHex(Flags))
36                  If InStrB(stmp, "$chflags") <> 0 Then stmp = Replace$(stmp, "$chflags", ChannelFlagsToString(Flags))
37                  If InStrB(stmp, "$crank") <> 0 Then stmp = Replace$(stmp, "$crank", clsClan)
38                  If InStrB(stmp, "$rank") <> 0 Then stmp = Replace$(stmp, "$rank", urank)
39                  If InStrB(stmp, "$message") <> 0 Then stmp = Replace$(stmp, "$message", Message)
                    
                    'append part of string
40                  OutputPart rtb, lcol, stmp, Not talk
                    'advance buffer
41                  buf = Mid$(buf, slen)
                Else
                    'check for more # chars
42                  If InStrB(Mid$(buf, esharp + 1), "#") <> 0 Then
                        'skip to last #
43                      buf = Mid$(buf, esharp + 1)
                        'goto next part
                        GoTo NextItem:
                    Else
                        'get part
44                      stmp = Mid$(buf, esharp + 1)
45                      stats = GetClientStats(Message)
                        If LenB(stats) = 0 Then
46                          If Left$(Message, 4) = "VD2D" Or Left$(Message, 4) = "PX2D" Then
                                stats = "open char"
                            Else
                                stats = "no stats"
                            End If
                        End If
                        'replace vars
                        If InStrB(stmp, "$flags_dec") <> 0 Then stmp = Replace$(stmp, "$flags_dec", Flags)
                        If InStrB(stmp, "$flags_raw") <> 0 Then stmp = Replace$(stmp, "$flags_raw", LongToHex(Flags))
47                      If InStrB(stmp, "$flags") <> 0 Then stmp = Replace$(stmp, "$flags", FlagsToString(Flags))
48                      If InStrB(stmp, "$ping") <> 0 Then stmp = Replace$(stmp, "$ping", Ping)
                        If InStrB(stmp, "$clan") <> 0 Then stmp = Replace$(stmp, "$clan", GetClanName(Message))
49                      If InStrB(stmp, "$user") <> 0 Then stmp = Replace$(stmp, "$user", GetTag(Username, True))
50                      If InStrB(stmp, "$uptime") <> 0 Then stmp = Replace$(stmp, "$uptime", Uptime)
51                      If InStrB(stmp, "$client") <> 0 Then stmp = Replace$(stmp, "$client", GetClientName(StrReverse$(Left$(Message, 4))))
52                      If InStrB(stmp, "$stats") <> 0 Then stmp = Replace$(stmp, "$stats", stats)
53                      If InStrB(stmp, "$channel") <> 0 Then stmp = Replace$(stmp, "$channel", Message)
54                      If InStrB(stmp, "$chflags_raw") <> 0 Then stmp = Replace$(stmp, "$chflags_raw", LongToHex(Flags))
55                      If InStrB(stmp, "$chflags") <> 0 Then stmp = Replace$(stmp, "$chflags", ChannelFlagsToString(Flags))
56                      If InStrB(stmp, "$crank") <> 0 Then stmp = Replace$(stmp, "$crank", clsClan)
57                      If InStrB(stmp, "$rank") <> 0 Then stmp = Replace$(stmp, "$rank", urank)
58                      If InStrB(stmp, "$message") <> 0 Then stmp = Replace$(stmp, "$message", Message)
                        'append part of string
59                      OutputPart rtb, lcol, stmp, Not talk
                        'clear buffer
                        buf = vbNullString
                    End If
                End If
            Loop
        End If
NextItem:
    Next
    'finally newline
60  OutputPart rtb, 0, vbNewLine
Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "Styles", "OutputEventFocus"
End Sub

Public Sub OutputEvent(rtb As RichTextBox, EID As Long, _
        Optional Username As String = vbNullString, _
        Optional Message As String = vbNullString, _
        Optional Flags As Long = 0, _
        Optional Ping As Long = 0, _
        Optional Uptime As String = 0, _
        Optional Extra As String = vbNullString)
On Error GoTo hErr:
    If Options.AutoLockAll Then Exit Sub
    If frmBot.Bot(rtb.Index).IsLocked Then Exit Sub
    Dim ucol As Long, urank As String, xfind As Integer, xdb As clsDatabaseUser, clsClan As String
    'get user color value
    If LenB(Username) Then
        ucol = GetUserColor(rtb.Index, Username, Flags)
        xfind = frmBot.Bot(rtb.Index).Database.Find(Username)
2       If xfind > -1 Then
            Set xdb = frmBot.Bot(rtb.Index).Database.GetUser(xfind)
3           If Not xdb Is Nothing Then urank = GetRankByID(xdb.RankID).RankName
        End If
        xfind = frmBot.Bot(rtb.Index).Clan.Find(Username)
        If xfind <> -1 Then clsClan = ClanRankToString(frmBot.Bot(rtb.Index).Clan.GetByIndex(xfind).Rank)
    End If
    'output time first
    OutputTime rtb
    'loop thru chat event strings
    Dim I As Integer, lcol As Long
    For I = 0 To UBound(ChatEvent)
        'found eid
        If ChatEvent(I).ce_eid = EID Then
            Dim buf As String, ssharp As Long, esharp As Long, scol As String, slen As Long, talk As Boolean
            'get talk bool
            talk = (EID = EID_TALK Or EID = EID_WHISPER Or EID = EID_WHISPERSENT Or EID = EID_EMOTE Or EID = &HA2 Or EID = &HA3 Or EID = &HA4)
            'get buf
            buf = ChatEvent(I).ce_string
            Do Until Len(buf) = 0
                'get first sharp
                ssharp = InStr(1, buf, "#")
                If ssharp = 0 Then GoTo Output:
                'get next sharp
                esharp = InStr(ssharp + 1, buf, "#")
                If esharp = 0 Then GoTo Output
                'get color name
                scol = Mid$(buf, ssharp + 1, esharp - ssharp - 1)
                'get len for later
                slen = InStr(esharp + 1, buf, "#")
                'check if the color == #ucol#
                If UCase$(scol) = "UCOL" Then
                    'get usercolor is not -1
                    If ucol <> -1 Then lcol = ucol
                Else
                    'get chatcolor
                    lcol = GetChatColor(scol)
                End If
Output:
                Dim stmp As String, stats As String
                'check length
                If slen > 0 Then
                    'get part
                    stmp = Mid$(buf, esharp + 1, slen - esharp - 1)
                    stats = GetClientStats(Message)
                    If LenB(stats) = 0 Then
                        If Left$(Message, 4) = "VD2D" Or Left$(Message, 4) = "PX2D" Then
                            stats = "open char"
                        Else
                            stats = "no stats"
                        End If
                    End If
                    'replace vars
                    If InStrB(stmp, "$flags_dec") <> 0 Then stmp = Replace$(stmp, "$flags_dec", Flags)
                    If InStrB(stmp, "$flags_raw") <> 0 Then stmp = Replace$(stmp, "$flags_raw", LongToHex(Flags))
                    If InStrB(stmp, "$flags") <> 0 Then stmp = Replace$(stmp, "$flags", FlagsToString(Flags))
                    If InStrB(stmp, "$ping") <> 0 Then stmp = Replace$(stmp, "$ping", Ping)
                    If InStrB(stmp, "$user") <> 0 Then stmp = Replace$(stmp, "$user", GetTag(Username, True))
                    If InStrB(stmp, "$uptime") <> 0 Then stmp = Replace$(stmp, "$uptime", Uptime)
                    If InStrB(stmp, "$clan") <> 0 Then stmp = Replace$(stmp, "$clan", GetClanName(Message))
                    If InStrB(stmp, "$client") <> 0 Then stmp = Replace$(stmp, "$client", GetClientName(StrReverse$(Left$(Message, 4))))
                    If InStrB(stmp, "$stats") <> 0 Then stmp = Replace$(stmp, "$stats", stats)
                    If InStrB(stmp, "$channel") <> 0 Then stmp = Replace$(stmp, "$channel", Message)
                    If InStrB(stmp, "$chflags_raw") <> 0 Then stmp = Replace$(stmp, "$chflags_raw", LongToHex(Flags))
                    If InStrB(stmp, "$chflags") <> 0 Then stmp = Replace$(stmp, "$chflags", ChannelFlagsToString(Flags))
                    If InStrB(stmp, "$crank") <> 0 Then stmp = Replace$(stmp, "$crank", clsClan)
                    If InStrB(stmp, "$rank") <> 0 Then stmp = Replace$(stmp, "$rank", urank)
                    If InStrB(stmp, "$message") <> 0 Then stmp = Replace$(stmp, "$message", Message)
                    'append part of string
                    OutputPart rtb, lcol, stmp, Not talk
                    'advance buffer
                    buf = Mid$(buf, slen)
                Else
                    'check for more # chars
                    If InStrB(Mid$(buf, esharp + 1), "#") <> 0 Then
                        'skip to last #
                        buf = Mid$(buf, esharp + 1)
                        'goto next part
                        GoTo NextItem:
                    Else
                        'get part
                        stmp = Mid$(buf, esharp + 1)
                        stats = GetClientStats(Message)
                        If LenB(stats) = 0 Then
                            If Left$(Message, 4) = "VD2D" Or Left$(Message, 4) = "PX2D" Then
                                stats = "open char"
                            Else
                                stats = "no stats"
                            End If
                        End If
                        'replace vars
                        If InStrB(stmp, "$flags_dec") <> 0 Then stmp = Replace$(stmp, "$flags_dec", Flags)
                        If InStrB(stmp, "$flags_raw") <> 0 Then stmp = Replace$(stmp, "$flags_raw", LongToHex(Flags))
                        If InStrB(stmp, "$flags") <> 0 Then stmp = Replace$(stmp, "$flags", FlagsToString(Flags))
                        If InStrB(stmp, "$ping") <> 0 Then stmp = Replace$(stmp, "$ping", Ping)
                        If InStrB(stmp, "$clan") <> 0 Then stmp = Replace$(stmp, "$clan", GetClanName(Message))
                        If InStrB(stmp, "$user") <> 0 Then stmp = Replace$(stmp, "$user", GetTag(Username, True))
                        If InStrB(stmp, "$uptime") <> 0 Then stmp = Replace$(stmp, "$uptime", Uptime)
                        If InStrB(stmp, "$client") <> 0 Then stmp = Replace$(stmp, "$client", GetClientName(StrReverse$(Left$(Message, 4))))
                        If InStrB(stmp, "$stats") <> 0 Then stmp = Replace$(stmp, "$stats", stats)
                        If InStrB(stmp, "$channel") <> 0 Then stmp = Replace$(stmp, "$channel", Message)
                        If InStrB(stmp, "$chflags_raw") <> 0 Then stmp = Replace$(stmp, "$chflags_raw", LongToHex(Flags))
                        If InStrB(stmp, "$chflags") <> 0 Then stmp = Replace$(stmp, "$chflags", ChannelFlagsToString(Flags))
                        If InStrB(stmp, "$crank") <> 0 Then stmp = Replace$(stmp, "$crank", clsClan)
                        If InStrB(stmp, "$rank") <> 0 Then stmp = Replace$(stmp, "$rank", urank)
                        If InStrB(stmp, "$message") <> 0 Then stmp = Replace$(stmp, "$message", Message)
                        'append part of string
                        OutputPart rtb, lcol, stmp, Not talk
                        'clear buffer
                        buf = vbNullString
                    End If
                End If
            Loop
        End If
NextItem:
    Next
    'finally newline
    OutputPart rtb, 0, vbNewLine
Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "Styles", "OutputEvent"
End Sub
